package ch.frankel.blog.hibernate.model;

import static javax.persistence.GenerationType.AUTO;
import static javax.persistence.TemporalType.DATE;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Temporal;

import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.SQLDelete;

/**
 * A product. Shows how to manage logical deletion.
 * 
 * @author Nicolas Frnkel
 * @since 19 fvr. 2010
 */
@Entity
@FilterDef(name = "activeProducts")
@Filter(name = "activeProducts", condition = "DELETION_DATE IS NULL")
@SQLDelete(sql = "UPDATE PRODUCT SET DELETION_DATE=CURRENT_DATE WHERE ID=?")
public class Product {

    /** Id. */
    @Id
    @Column(nullable = false)
    @GeneratedValue(strategy = AUTO)
    private Integer id;

    /** Deletion date. */
    @Temporal(DATE)
    @Column(name = "DELETION_DATE")
    private Date deleted;

    /**
     * Gets the {@link #id} of the product.
     * 
     * @return Product's id
     */
    public Integer getId() {

        return id;
    }

    public void setId(Integer aId) {

        id = aId;
    }
}
